#include "../mdk/mdk.h"
#include <windows.h>
#include "overloaderdata.h"

#pragma optimize ("awy", on) 

CMachineParameter const paraPolarityType =
{
	pt_byte,
	"----------",
	"PolarityType",
	0,
	3,
	0xFF,
	MPF_STATE,
	0
};

CMachineParameter const paraMeld =
{
	pt_byte,
	"----------",
	"Stereo Meld",
	0,
	0xFE,
	0xFF,
	MPF_STATE,
	127
};

CMachineParameter const paraLeftGain =
{
	pt_byte,
	"----------",
	"Left Gain",
	0,
	0xFE,
	0xFF,
	MPF_STATE,
	0xFE
};

CMachineParameter const paraMiddleGain =
{
	pt_byte,
	"Gain-Center",
	"Center Gain",
	0,
	0xFE,
	0xFF,
	MPF_STATE,
	0xFE
};

CMachineParameter const paraRightGain =
{
	pt_byte,
	"----------",
	"Right Gain",
	0,
	0xFE,
	0xFF,
	MPF_STATE,
	0xFE
};

CMachineParameter const *pParameters[] = { &paraPolarityType, &paraMeld, &paraLeftGain, &paraMiddleGain, &paraRightGain, &paraMiddleGain, &paraMiddleGain, &paraMiddleGain, &paraRightGain, &paraMiddleGain };
CMachineAttribute const *pAttributes[] = { NULL, };

#pragma pack(1)		

class gvals
{
public:
	byte type;
	byte mix;
	byte leftgain;
	byte middlegain;
	byte rightgain;
	byte t2ype;
	byte m2ix;
	byte l2eftgain;
	byte m2iddlegain;
	byte r2ightgain;
};

#pragma pack()


CMachineInfo const MacInfo = 
{
	MT_EFFECT,
	MI_VERSION,	
	MIF_DOES_INPUT_MIXING,
	0,										// min tracks
	0,										// max tracks
	10,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	pAttributes,
	"CyanPhase AtomStereoMeld",								// name
	"Stereo Meld",								// short name
	"Edward L. Blake",						// author
	"&About..."
};


class miex : public CMDKMachineInterfaceEx { };

class mi : public CMDKMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Tick();

	virtual void MDKInit(CMachineDataInput * const pi);
	virtual bool MDKWork(float *psamples, int numsamples, int const mode);
	virtual bool MDKWorkStereo(float *psamples, int numsamples, int const mode);
	virtual void mi::Command(int const i);

	virtual void MDKSave(CMachineDataOutput * const po);

	virtual char const *DescribeValue(int const param, int const value);

public:
	virtual CMDKMachineInterfaceEx *GetEx() { return &ex; }
	virtual void OutputModeChanged(bool stereo) {}


public:
	miex ex;

public:
	float leftgain, middlegain, rightgain;
	float valve, antivalve;

	int type;

	gvals gval;

};


mi::mi() {  GlobalVals = &gval; }
mi::~mi() { }

void mi::MDKInit(CMachineDataInput * const pi)
{
	SetOutputMode( true );	//	If true, the MDKWork will never be called, meaning that Buzz will convert a mono signal to
							//	stereo itself and call MDKWorkStereo insted.
							//	If false, MDKWork will be called in mono cases, and the output should be mono
	leftgain = 1.0f;
	middlegain = 1.0f;
	rightgain = 1.0f;

	valve = (254.0f - 127.0f)/254.0f;
	antivalve = (127.0f)/254.0f;

	type = 0;
}

void mi::MDKSave(CMachineDataOutput * const po) { }

void mi::Tick() {
	unsigned int f = 0;

	if (gval.mix != 0xFF) {
		f = gval.mix;
		valve = (254.0f - f)/254.0f;
		antivalve = (f)/254.0f;	
	};

	if (gval.type != 0xFF) {
		type = gval.type;
	};

	if (gval.leftgain != 0xFF) {
		leftgain = (gval.leftgain / 254.0f);
	};

	if (gval.middlegain != 0xFF) {
		middlegain = (gval.middlegain / 254.0f);
	};

	if (gval.rightgain != 0xFF) {
		rightgain = (gval.rightgain / 254.0f);
	};

}

bool mi::MDKWork(float *psamples, int numsamples, int const mode)
{
	return false;
}

bool mi::MDKWorkStereo(float *psamples, int numsamples, int const mode)
{
	if (mode==WM_WRITE)
		return false;
	if (mode==WM_NOIO)
		return false;
	if (mode==WM_READ)		// <thru>
		return true;

	float inL, inR, leftb, midb, rightb;
	int	i;

	switch (type) {
	case 0: // +L +R
		for( i=0; i<numsamples*2; i++ ) {

			inL = psamples[i];
			inR = psamples[i+1];


			leftb = (valve*inL) * leftgain;
			midb = ((antivalve * inL) + (antivalve * inR)) * middlegain;
			rightb = (valve*inR) * rightgain;

			psamples[i] = leftb + midb;
			i++;
			psamples[i] = rightb + midb;
		};
		break;
	case 1: // +L -R
		for( i=0; i<numsamples*2; i++ ) {

			inL = psamples[i];
			inR = -(psamples[i+1]);


			leftb = (valve*inL) * leftgain;
			midb = ((antivalve * inL) + antivalve * inR) * middlegain;
			rightb = (valve*inR) * rightgain;

			psamples[i] = leftb + midb;
			i++;
			psamples[i] = rightb + midb;
		};
		break;
	case 2: // -L +R
		for( i=0; i<numsamples*2; i++ ) {

			inL = -(psamples[i]);
			inR = psamples[i+1];


			leftb = (valve*inL) * leftgain;
			midb = ((antivalve * inL) + antivalve * inR) * middlegain;
			rightb = (valve*inR) * rightgain;

			psamples[i] = leftb + midb;
			i++;
			psamples[i] = rightb + midb;
		};
		break;
	case 3: // -L -R
		for( i=0; i<numsamples*2; i++ ) {

			inL = -(psamples[i]);
			inR = -(psamples[i+1]);


			leftb = (valve*inL) * leftgain;
			midb = ((antivalve * inL) + antivalve * inR) * middlegain;
			rightb = (valve*inR) * rightgain;

			psamples[i] = leftb + midb;
			i++;
			psamples[i] = rightb + midb;
		};
		break;
	default:
		break;
	}
	return true;
}

void mi::Command(int const i)
{
	switch (i)
	{
	case 0:
		MessageBox(NULL,"CyanPhase AtomStereoMeld 1.0\n\nCopyright 2000 Edward L. Blake\nEmail: blakee@rovoscape.com","About CyanPhase AtomStereoMeld",MB_OK|MB_SYSTEMMODAL);
		break;
	default:
		break;
	}
}
char const *mi::DescribeValue(int const param, int const value)
{
	switch(param)
	{
	case 0:
		return "pramtest_test1";
	case 1:
		return "pramtest_test2";
	case 2:
		return "----------0";
	case 3:
		return "test";
	case 4:
		return "----------0";
	case 5:
		return "test1";
	case 6:
		return "test2";
	case 7:
		return "test3";
	case 8:
		return "----------0";
	case 9:
		return "test B";
	default:
		return NULL;
	}
}

//
// Recommended dimensions for images: 402x16
//

BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved )
{
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH:
	{
		overloaderdata_initialize();
		overloaderdata_registerimage("pramtest_test1",(HINSTANCE)hModule,"test1");
		overloaderdata_registerimage("pramtest_test2",(HINSTANCE)hModule,"test2");
	}
		break;
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}

#pragma optimize ("", on) 

DLL_EXPORTS

